<?php
// Include necessary dependencies and setup
session_start();
include 'connection.php';
require_once '../vendor/autoload.php'; // You'll need to include the correct autoload path
file_put_contents('received_data.log', file_get_contents('php://input'));
use AfricasTalking\SDK\AfricasTalking;

// Set your API credentials
$username = 'sandbox'; // Your Africa's Talking username
$apiKey = '5146aeb4d8addc18b1761794716e71e6c9aad3c007484c98f72bfaa31063139b'; // Your Africa's Talking API key

// Initialize the Africa's Talking SDK
$AT = new AfricasTalking($username, $apiKey);

// Get one of the services
$sms = $AT->sms();

// Define your short code and message
$shortCode = '73190';

// Handle incoming SMS
$input = json_decode(file_get_contents('php://input'));

if ($input && isset($input->from) && isset($input->to) && isset($input->text)) {
    $from = $input->from;
    $to = $input->to;
    $text = $input->text;

    // Extract the application number from the incoming text
    $userInput = explode(' ', $text);
    $applicationNo = $userInput[1];

    // Check if the message is from the appropriate shortcode
    if ($to === $shortCode) {
        try {
            $query = "SELECT (BalTotalDebit - BalTotalCredit) AS balance FROM customerdetails WHERE ApplicationNo LIKE ?";
            $likeAccount = '%' . $applicationNo . '%';
            // Remove white spaces
            $acc = preg_replace('/\s+/', '', $likeAccount);

            // Prepare the statement
            $stmt = $mysqli->prepare($query);

            if ($stmt === false) {
                throw new Exception("Error preparing statement: " . $mysqli->error);
            }

            // Bind the parameter
            $stmt->bind_param("s", $acc);

            // Execute the query
            if ($stmt->execute()) {
                // Get the result
                $result = $stmt->get_result();

                $jsonResult = array('query' => $query, 'status' => 'success');

                if ($result->num_rows === 0) {
                    echo "No balance found for User with $applicationNo";
                    echo json_encode(["Status" => "No Balance Found"]);
                } else {
                    $balance = $result->fetch_assoc()['balance'];
                    echo "Balance: $balance\n";
                    echo strlen($acc) . "\n";
                    $responseMessage = "Your balance is: " . number_format($balance);
                    sendResponse($from, $responseMessage);
                    http_response_code(200);
                    // echo json_encode(["Status" => "Success", "Balance" => $balance]);
                }

                // Close the result set
                $result->close();
            } else {
                throw new Exception("Error executing query: " . $stmt->error);
            }

            // Close the statement
            $stmt->close();
        } catch (Exception $error) {
            echo "Error in QueryDB: " . $error->getMessage();
        }

    } else {
        echo "Something is wrong with the incoming message";
        http_response_code(400);
    }
}

function sendResponse($recipient, $message) {
    global $shortCode, $username, $apiKey;

    // Create an instance of the SMS class
    $sms = new AfricasTalking\SDK\SMS($username, $apiKey);

    // Send the response
    try {
        $result = $sms->send([
            'from' => $shortCode,
            'to' => $recipient,
            'message' => $message,
        ]);

        if ($result['status'] === 'success') {
            echo 'Message sent successfully';
        } else {
            echo 'Something went wrong with message sending';
        }
    } catch (Exception $e) {
        echo 'Error: ' . $e->getMessage();
    }
}

?>
