<?php
// Define a log file path
$logFilePath = 'delivery.log';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception("HTTP POST method is required for this endpoint.");
    }

    $data = file_get_contents('php://input');
    $jsonData = json_decode($data, true);

    if ($jsonData === null) {
        throw new Exception("Invalid JSON data received.");
    }

    echo "Received report:\n" . json_encode($jsonData, JSON_PRETTY_PRINT);
    http_response_code(200);
} catch (Exception $e) {
    // Log the exception message to the file
    $errorMessage = "Error: " . $e->getMessage();
    error_log(`$errorMessage/n`, 3, $logFilePath);

    echo $errorMessage;
    http_response_code(400); // or 405, depending on the specific error
}
?>
